﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class PersonController : Controller
    {
        #region Get Methods

        // GET: /Person/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<NEW_PERSON> list = new List<NEW_PERSON>();
                foreach (NEW_PERSON pers in db.NEW_PERSON.ToList())
                {
                    list.Add(pers);
                }
                return View(list);
            }
        }

        //Get: /Person/Create
        public ActionResult Create()
        {
            return View();
        }

        // GET: /Person/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.NEW_PERSON.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /Person/Create
        [HttpPost]
        public ActionResult Create(NEW_PERSON pers)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.NEW_PERSON.Add(pers);
                    db.SaveChanges();
                }

                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, NEW_PERSON pers)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(pers).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
